<?php

namespace ExternalImporter\application\components;

defined('\ABSPATH') || exit;

use ExternalImporter\application\Plugin;
use ExternalImporter\application\admin\LicConfig;
use ContentEgg\application\helpers\TemplateHelper;

/**
 * LManager class file
 *
 * @author keywordrush.com <support@keywordrush.com>
 * @link https://www.keywordrush.com
 * @copyright Copyright &copy; 2021 keywordrush.com
 */
class LManager {

    const CACHE_TTL = 86400;

    private $data = null;
    private static $instance = null;

    public static function getInstance()
    {
        if (self::$instance == null)
            self::$instance = new self;

        return self::$instance;
    }

    public function adminInit()
    {
        \add_action('admin_notices', array($this, 'displayNotice'));
        $this->hideNotice();
    }

    public function getData($force = false)
    {
        if (!LicConfig::getInstance()->option('license_key'))
            return array();

        if (!$force && $this->data !== null)
            return $this->data;

        $this->data = $this->getCache();
        if ($this->data === false || $force)
        {
            $data = $this->remoteRetrieve();
            if (!$data || !is_array($data))
                $data = array();

            $this->data = $data;
            $this->saveCache($this->data);
        }

        return $this->data;
    }

    public function remoteRetrieve()
    {
        if (!$response = Plugin::apiRequest(array('method' => 'POST', 'timeout' => 10, 'body' => $this->getRequestArray('license'))))
            return false;

        if (!$result = json_decode(\wp_remote_retrieve_body($response), true))
            return false;

        return $result;
    }

    public function saveCache($data)
    {
        \set_transient(Plugin::getShortSlug() . '_' . 'ldata', $data, self::CACHE_TTL);
    }

    public function getCache()
    {
        return \get_transient(Plugin::getShortSlug() . '_' . 'ldata');
    }

    public function deleteCache()
    {
        \delete_transient(Plugin::getShortSlug() . '_' . 'ldata');
    }

    private function getRequestArray($cmd)
    {
        return array('cmd' => $cmd, 'd' => parse_url(\site_url(), PHP_URL_HOST), 'p' => Plugin::product_id, 'v' => Plugin::version(), 'key' => LicConfig::getInstance()->option('license_key'));
    }

    public function isConfigPage()
    {
        if ($GLOBALS['pagenow'] == 'admin.php' && isset($_GET['page']) && $_GET['page'] == 'external-importer-lic')
            return true;
        else
            return false;
    }

    public function displayNotice()
    {
        return;
        if (LManager::isNulled() && time() > 1633717521)
        {
            $notice_date = \get_option(Plugin::slug . '_nulled_notice_date', 0);
            if ($notice_date && time() > $notice_date + 86400 * 3)
            {
                LManager::deactivateLic();
                return;
            }

            $this->displayNulledNotice();
            return;
        }

        if (!$data = LManager::getInstance()->getData())
            return;

        if ($data['activated_on'] && $data['activated_on'] != preg_replace('/^www\./', '', strtolower(parse_url(\site_url(), PHP_URL_HOST))))
        {
            $this->displayLicenseMismatchNotice();
            return;
        }

        if (time() >= $data['expiry_date'])
        {
            $this->displayExpiredNotice($data);
            return;
        }

        $days_left = floor(($data['expiry_date'] - time()) / 3600 / 24);
        if ($days_left >= 0 && $days_left <= 21)
        {
            $this->displayExpiresSoonNotice($data);
            return;
        }

        if ($this->isConfigPage())
        {
            $this->displayActiveNotice($data);
            return;
        }
    }

    public function displayActiveNotice(array $data)
    {
        $this->addInlineCss();
        $purchase_uri = '/product/purchase/1019';
        $days_left = floor(($data['expiry_date'] - time()) / 3600 / 24);

        echo '<div class="notice notice-success exi-notice"><p>';
        echo sprintf(__('License status: <span class="exi-label exi-label-%s">%s</span>.', 'external-importer'), strtolower($data['status']), strtoupper($data['status']));
        if ($data['status'] == 'active')
            echo ' ' . __('You are receiving automatic updates.', 'external-importer');
        echo '<br />' . sprintf(__('Expires at %s (%d days left).', 'external-importer'), gmdate('F d, Y H:i', $data['expiry_date']) . ' GMT', $days_left);
        echo '</p>';
        echo '<p>';
        $this->displayCheckAgainButton();

        echo ' ' . sprintf('<a class="button-primary" target="_blank" href="%s">%s</a>', Plugin::website . '/login?return=' . urlencode($purchase_uri), "&#10003; " . __('Extend now', 'external-importer'));
        if ((int) $data['extend_discount'])
            echo ' <small>' . sprintf(__('with a %d%% discount', 'external-importer'), $data['extend_discount']) . '</small>';

        echo '</p></div>';
    }

    public function displayExpiresSoonNotice(array $data)
    {
        if (\get_transient('exi_hide_notice_lic_expires_soon') && !$this->isConfigPage())
            return;

        $this->addInlineCss();
        $purchase_uri = '/product/purchase/1019';
        $days_left = floor(($data['expiry_date'] - time()) / 3600 / 24);
        echo '<div class="notice notice-warning exi-notice">';
        echo '<p>';
        if (!$this->isConfigPage())
        {
            $hide_notice_uri = \add_query_arg(array('exi_hide_notice' => 'lic_expires_soon', '_exi_notice_nonce' => \wp_create_nonce('hide_notice')), $_SERVER['REQUEST_URI']);
            echo '<a href="' . $hide_notice_uri . '" class="exi-notice-close notice-dismiss">' . __('Dismiss', 'external-importer') . '</a>';
        }
        echo '<strong>' . __('License expires soon', 'external-importer') . '</strong><br />';
        echo sprintf(__('Your %s license expires at %s (%d days left).', 'external-importer'), Plugin::getName(), gmdate('F d, Y H:i', $data['expiry_date']) . ' GMT', $days_left);
        echo ' ' . __('You will not receive automatic updates, bug fixes, and technical support.', 'external-importer');
        echo '</p>';
        echo '<p>';
        $this->displayCheckAgainButton();
        echo ' ' . sprintf('<a class="button-primary" target="_blank" href="%s">%s</a>', Plugin::website . '/login?return=' . urlencode($purchase_uri), "&#10003; " . __('Extend now', 'external-importer'));
        if ((int) $data['extend_discount'])
            echo ' <span class="exi-label exi-label-success">' . sprintf(__('with a %d%% discount', 'external-importer'), $data['extend_discount']) . '</span>';
        echo '</p>';
        echo '</div>';
    }

    public function displayExpiredNotice(array $data)
    {
        if (\get_transient('exi_hide_notice_lic_expired') && !$this->isConfigPage())
            return;

        $this->addInlineCss();
        $purchase_uri = '/product/purchase/1019';
        echo '<div class="notice notice-error exi-notice">';
        echo '<p>';

        if (!$this->isConfigPage())
        {
            $hide_notice_uri = \add_query_arg(array('exi_hide_notice' => 'lic_expired', '_exi_notice_nonce' => \wp_create_nonce('hide_notice')), $_SERVER['REQUEST_URI']);
            echo '<a href="' . $hide_notice_uri . '" class="exi-notice-close notice-dismiss">' . __('Dismiss', 'external-importer') . '</a>';
        }

        echo '<strong>' . __('License expired', 'external-importer') . '</strong><br />';
        echo sprintf(__('Your %s license expired on %s.', 'external-importer'), Plugin::getName(), gmdate('F d, Y H:i', $data['expiry_date']) . ' GMT');
        echo ' ' . __('You are not receiving automatic updates, bug fixes, and technical support.', 'external-importer');
        echo '</p>';
        echo '<p>';
        $this->displayCheckAgainButton();
        echo ' ' . sprintf('<a class="button-primary" target="_blank" href="%s">%s</a>', Plugin::website . '/login?return=' . urlencode($purchase_uri), "&#10003; " . __('Renew now', 'external-importer'));
        echo '</p></div>';
    }

    public function displayLicenseMismatchNotice()
    {
        $this->addInlineCss();
        echo '<div class="notice notice-error exi-notice"><p>';
        echo '<strong>' . __('License mismatch', 'external-importer') . '</strong><br />';
        echo sprintf(__("Your %s license doesn't match your current domain.", 'external-importer'), Plugin::getName());
        echo ' ' . sprintf(__('If you wish to continue using the plugin then you must <a target="_blank" href="%s">revoke</a> the license and then <a href="%s">reactivate</a> it again or <a target="_blank" href="%s">buy a new license</a>.', 'external-importer'), Plugin::panelUri, \get_admin_url(\get_current_blog_id(), 'admin.php?page=external-importer-lic'), 'https://www.keywordrush.com/externalimporter/pricing');
        echo '</p></div>';
    }

    public function displayCheckAgainButton()
    {
        echo '<form style="display: inline;" action=" ' . \get_admin_url(\get_current_blog_id(), 'admin.php?page=external-importer-lic') . '" method="POST">';
        echo '<input type="hidden" name="exi_cmd" id="exi_cmd" value="refresh" />';
        echo '<input type="hidden" name="nonce_refresh" value="' . \wp_create_nonce('license_refresh') . '"/>';
        echo '<input type="submit" name="submit3" id="submit3" class="button" value="&#8635; ' . __('Check again', 'external-importer') . '" />';
        echo '</form>';
    }

    public function hideNotice()
    {
        if (!isset($_GET['exi_hide_notice']))
            return;

        if (!isset($_GET['_exi_notice_nonce']) || !\wp_verify_nonce($_GET['_exi_notice_nonce'], 'hide_notice'))
            return;

        $notice = $_GET['exi_hide_notice'];

        if (!in_array($notice, array('lic_expires_soon', 'lic_expired')))
            return;

        if ($notice == 'lic_expires_soon')
            $expiration = 7 * 24 * 3600;
        elseif ($notice == 'lic_expired')
            $expiration = 90 * 24 * 3600;
        else
            $expiration = 0;

        \set_transient('exi_hide_notice_' . $notice, true, $expiration);

        \wp_redirect(\remove_query_arg(array('exi_hide_notice', '_exi_notice_nonce'), \wp_unslash($_SERVER['REQUEST_URI'])));
        exit;
    }

    public function addInlineCss()
    {
        echo '<style>.exi-notice a.exi-notice-close {position:static;float:right;top:0;right0;padding:0;margin-top:-20px;line-height:1.23076923;text-decoration:none;}.exi-notice a.exi-notice-close::before{position: relative;top: 18px;left: -20px;}.exi-notice img {float:left;width:40px;padding-right:12px;}</style>';
    }

    public function displayNulledNotice()
    {
        return;
        $activation_date = \get_option(Plugin::slug . '_first_activation_date', false);
        if ($activation_date && $activation_date < time() + 86400 * 3)
            return;

        $notice_date = \get_option(Plugin::slug . '_nulled_notice_date');
        if (!$notice_date)
        {
            $notice_date = time();
            \update_option(Plugin::slug . '_nulled_notice_date', $notice_date);
        }
        $valid_date = $notice_date + 86400 * 2;

        $this->addInlineCss();
        echo '<div class="notice notice-error exi-notice" style="padding: 10px;">';
        echo '<img src=" ' . \ExternalImporter\PLUGIN_RES . '/img/logo.png' . '" width="40" />';
        echo '<strong>Don’t Use Cracked Plugins on Production Sites – It’s Not Worth It!</strong><br />';
        echo sprintf('<p>You are using a cracked version of %s plugin. This is an illegal and dangerous copy of the plugin.', Plugin::getName());
        echo '<br/>Cracked plugins often have backdoors and other malware injected into code that is used to get full third-party access to your site, distribute SEO spam, viruses and redirect site visitors. Your site will be probably blacklisted by Google.</p>';
        echo '<p>Please note: You can purchase External Importer Pro only on our <a target="_blank" href="https://www.keywordrush.com/?utm_source=ei&utm_medium=referral&utm_campaign=legal">official site</a>. If you purchased your pirated copy on any other site, we recommend requesting a refund and reinstalling the plugin (your existing settings and plugin data are safe!).</p>';
        echo '<p>The official version includes <u>direct support, automatic updates</u> and a guarantee of proper work.</p>';

        if ($valid_date > time())
        {
            echo sprintf('Use code <b>LEGAL25</b> for a 25%% discount (valid until %s).', TemplateHelper::dateFormatFromGmt($valid_date, false));
            echo '<br><br><a target="_blank" class="button button-primary button-large" href="https://www.keywordrush.com/externalimporter/pricing?ref=LEGAL25&utm_source=ei&utm_medium=referral&utm_campaign=legal">Apply Coupon</a>';
        } else
            echo '<a target="_blank" class="button button-primary button-large" href="https://www.keywordrush.com/externalimporter/pricing?utm_source=ei&utm_medium=referral&utm_campaign=legal">Buy Now</a>';

        echo '</div>';
    }

    public static function isNulled()
    {
        return false;
        $l = LicConfig::getInstance()->option('license_key');
        if (!$l)
            return false;
        if (!LManager::isValidLicFormat($l))
            return true;
        if (in_array(md5($l), LManager::getNulledLics()))
            return true;
        return false;
    }

    public static function isValidLicFormat($value)
    {
        if (preg_match('/[^0-9a-zA-Z_~\-]/', $value))
            return false;
        if (strlen($value) != 32 && strlen($value) != 36)
            return false;
        return true;
    }

    public static function getNulledLics()
    {
        return array('782827cbd9dab148548f41184850a17d','bc57aa5923d803c465184623de14114e','1342e3cd2142a46010550cb8d1c07a4a','dd025e37d236de2346a09a51331c1232','fded028cb4a7f4e5300f4b909fb9ff22','c52fadb5a51c73aeb510932d75a6ebc4','f875624c61165879063a51e9239f112b','d92d03899e674d265c54221de87f47ab','f6d39075bfceb776ebb6bf79c4b46114','a5c2305222b9bea26a5611101c93db86','4d89b9ea00db777228ac587149b7b403','357c950561096089e2275dab50483d61','86d55dbe32b9bced65b25e6d3c3746e4','f3f8db4cb0837916c1c3ee961950bfdb','2fc7e4480a15ed988c18b6051a34c5b4','18d18341724e616e6038b30cc1afb103','50896af36231cad47384235bd074a24f','4a21fce420d531857b5c07368bf07072','dc0bf117f2d2ca6e883b69bb7527964f','a282d805e6e7b5f8f96ddcec966809fc','e95cab97ed66287bffec97513943c453','60a9115ad107ba9778e761ecc57a2521','9973938d5a865f7ddaf3f5fd13f61036','14b4065233f9bd21d4cf5d1daa6390ff','ab7a7f8d13a683cfad86cbfe3d1bdc12','4530cd97c2f0e44a4fa57bee3f41b1db','296833ad0648c97931a805490c044b12','6d05d7139c2f3d3871c9b0cdf3982603','19b18b505d21b47da99f0a777f5d8f81','468320301b64c7669e4657cf6353f7bc','b473c2a1fb60142527780b829ba0ba76','63ee89bd518501b66097688a476f3e4b','981540125d6dbc442da361de72eb70fc','ed06b064849e861eb3380f12c0136273','c027e96dc12536569be4f11aefb16bb2','ca7c9cbad07b024f0433426f9a84f29f','c098a9954983fabda58801b0b6c8f787','36dcee17c23dce6f6975f0710192acfe','a06b3890ddfc3f3faae15da1b2b3b614','cd9e459ea708a948d5c2f5a6ca8838cf','560e12b4143100d5324cf0ca1fd73c80','2e32c7597c2241c44a41aac18fc3255e','15b1104e706129580e4bdbe796502b77','dd469b3e16bd8f151751d61445438ecb','d8b4d3e2933abf25a6f6f49811459fd0','593545b717345d61df3cd2667a731d1f','eb974e8d25c7d8e63d36d0610d759a29','15f72ed03221006fda1fbf112981be03','fa549e08cc7a2637def7e4028f93ee31','d068c88e1727301c787b229d938185a6','1130d4c1fcca8b55fc9adab0a907a058','3050138fffd03b322fee0c6ceb9dc204','36a31db6bda7d2aeac517f2e943add8d','6ce23fc6794aa40d8f6e96b0d6d4b80b','6fbdcfc6d3ab9bd5985274b3d386615e','f1cab0a3fbe94fdce1cec5f5a48e2f68','d61b8b704cf3921a841ddc00d268c9fe','b0dafccca4919b60f2aef18235b05f44','935c6b67a69c1b988bfb1e73f3ddc7bf','9ff9eba04febf154374798e67d086c14','854277ac94772d5b72928bfdf67ca2a1','770c2830dc9e057b1c97febac6256c3e','675bf6ae2966e89be8302f29a5d1c2e1','ea95322b3432c2d884cb787ee9257807','aea42a0a8a870e7f1a035d67c62419c1','78d167d9bbd33709ff0a6d908c50ca8a','a7208c404b28ba7422b3330fd1aa6fe9','1c7b471fbfbca207658800945c76ac66','732dd0b39b6483319f092301fc9a160b','ad8f6c5337c70afb96479682271452e8','8c843a67c9795b6c7f64207fe669ff6c','c0d3818cb0ea60ddd037aed40b85ed8a','477f79182b686d15531f9e5ff85d2ca8','3b5d75688342a5008893a27ed9278945','2ccffae25b74950a13540ea699b3d576','3cbb6fd74d432d941271f2f37937c09b','df40440b0b1d8fe5f49cba3dc543f2a4','74f7ad3ab536baea28476b3aebbd2543','216a567115e7c454377262b0d1978a28','7751be51d8932f4da27b5bd8cc620165','94ca33c37f77c8dd37f07a4e29cef697','5a9355643f606c1180def0813b321dce','6ce822b6177738de4992989da6b8e4fa','0af06f2257fad1d2543ff7e41fc4f0ea','ae8ebf98c8d06ea30504a9898c77813c','bac6fa8846a73ba00dcd1b863dd0b90a','1f92b6f95d6c0e0c7605dbf023fd838b','bf80b62f9a843fb4d9255535a428e6ce','e011076487ac48aae8e9b31e65d76fdc','2166e4938975ba9b30ae0bd90a536fa2','1e0a43725379325ce601a55ce82d103e','e74bf2cde0104a108a4e41c9d518789f');
    }

    public static function deactivateLic()
    {
        \update_option(Plugin::slug . '_nulled_key', LicConfig::getInstance()->option('license_key'));
        \update_option(Plugin::slug . '_nulled_deactiv_date', time());
        \delete_option(LicConfig::getInstance()->option_name());
    }

}
