<?php 
/*

Plugin Name: M-Pesa
Plugin URI: https://www.webscreationsdesign.com
Description: E-Commerce payment solution for M-Pesa Mobile Banking. Add 'M-Pesa Mobile Banking Payment' as an extra payment option in WooCommerce.
Version: 1.0
Author: Webscreations Design Group
Author URI: https://www.webscreationsdesign.com
License: Commercial
	
*/

defined('ABSPATH') or die('Ready for fun? :-) ');

add_filter('woocommerce_payment_gateways', 'dear_pesa_wmbp_pesa_payment_gateways');
function dear_pesa_wmbp_pesa_payment_gateways( $gateways ){
	$gateways[] = 'dear_pesaIT_wmbp_pesa';
	return $gateways;
}

add_action('plugins_loaded', 'dear_pesa_wmbp_pesa_plugin_activation');
function dear_pesa_wmbp_pesa_plugin_activation(){
	
	class dear_pesaIT_wmbp_pesa extends WC_Payment_Gateway {

		public $wmbp_pesa_number;
		public $number_type;
		public $order_status;
		public $instructions;
		public $domain;

		public function __construct(){
			$this->domain 				= 'stb';

			$this->id 					= 'dear_pesa_wmbp_pesa';
			$this->title 				= $this->get_option('title', 'M-Pesa Mobile Banking Payment');
			$this->description 			= $this->get_option('description', 'Makes your shopping experience easier');
			$this->method_title 		= __("M-Pesa Mobile Banking Payment", $this->domain);
			$this->method_description 	= __("Please fill up the form below, customize carefully", $this->domain );
			$this->icon 				= plugins_url('images/m-pesa.png', __FILE__);
			$this->has_fields 			= true;

			$this->dear_pesa_wmbp_pesa_options_fields();
			$this->init_settings();
			
			$this->wmbp_pesa_number = $this->get_option('wmbp_pesa_number');
			$this->number_type 	= $this->get_option('number_type');
			$this->order_status = $this->get_option('order_status');
			$this->instructions = $this->get_option('instructions');

			add_action( 'woocommerce_update_options_payment_gateways_'.$this->id, array( $this, 'process_admin_options' ) );
            add_filter( 'woocommerce_thankyou_order_received_text', array( $this, 'dear_pesa_wmbp_pesa_thankyou_page' ) );
            add_action( 'woocommerce_email_before_order_table', array( $this, 'dear_pesa_wmbp_pesa_email_instructions' ), 10, 3 );
		}


		public function dear_pesa_wmbp_pesa_options_fields(){
			$this->form_fields = array(
				'enabled' 	=>	array(
					'title'		=> __( 'Enable/Disable', $this->domain ),
					'type' 		=> 'checkbox',
					'label'		=> __( 'M-Pesa Mobile Banking Payment integration with WooCommerce', $this->domain ),
					'default'	=> 'yes'
				),
				'title' 	=> array(
					'title' 	=> __( 'Title', $this->domain ),
					'type' 		=> 'text',
					'default'	=> __( 'M-Pesa Mobile Banking Payment', $this->domain )
				),
				'description' => array(
					'title'		=> __( 'Description', $this->domain ),
					'type' 		=> 'textarea',
					'default'	=> __( 'Please complete your Payment via Mobile to our account at first, then fill up the form below.', $this->domain ),
					'desc_tip'    => true
				),
                'order_status' => array(
                    'title'       => __( 'Order Status', $this->domain ),
                    'type'        => 'select',
                    'class'       => 'wc-enhanced-select',
                    'description' => __( 'Choose whether status you wish after checkout.', $this->domain ),
                    'default'     => 'wc-on-hold',
                    'desc_tip'    => true,
                    'options'     => wc_get_order_statuses()
                ),				
				'wmbp_pesa_number'	=> array(
					'title'			=> 'Your Mobile Number, which is used as Bank Account number',
					'description' 	=> __( 'Add a Mobile no which will be shown in checkout page', $this->domain ),
					'type'			=> 'text',
					'desc_tip'      => true
				),
				'number_type'	=> array(
					'title'			=> __( 'Account Type, If necessary. Mobile is default', $this->domain ),
					'type'			=> 'select',
					'class'       	=> 'wc-enhanced-select',
					'description' 	=> __( 'Select account type', $this->domain ),
					'options'	=> array(
					    'Mobile'	 => __( 'Mobile', $this->domain ),
					    'Personal'	 => __( 'Personal', $this->domain ),
					    'NGO'	     => __( 'NGO', $this->domain ),
						'Agent'	     => __( 'Agent', $this->domain ),
						'Company'	 => __( 'Company', $this->domain ),

					),
					'desc_tip'      => true
				),				
                'instructions' => array(
                    'title'       	=> __( 'Instructions', $this->domain ),
                    'type'        	=> 'textarea',
                    'description' 	=> __( 'Instructions that will be added to the thank you page and emails.', $this->domain ),
                    'default'     	=> __( 'Thanks for puchasing through Mobile. We will check and give you update as soon as possible.', $this->domain ),
                    'desc_tip'    	=> true
                ),								
			);
		}


		public function payment_fields(){

			global $woocommerce;
			echo wpautop( wptexturize( "Pay first via M-Pesa at this ".$this->number_type." No: " ) );
			echo wpautop( wptexturize( "".$this->wmbp_pesa_number ) );

			?>
				<p>
					<label for="wmbp_pesa_number"><?php _e( 'Type Your M-Pesa No.', $this->domain );?></label>
				</p>
				<p>
				</p>
				<p>
					<input type="text" name="wmbp_pesa_number" id="wmbp_pesa_number" placeholder="XXXXXXXXXXX">
				</p>
				<p>
					<label for="wmbp_pesa_transaction_id"><?php _e( 'Type Ref ID', $this->domain );?></label>
			    </p>
				<p>
					<input type="text" name="wmbp_pesa_transaction_id" id="wmbp_pesa_transaction_id" placeholder="01234567890">
				</p>
			<?php 
		}
		

		public function process_payment( $order_id ) {
			global $woocommerce;
			$order = new WC_Order( $order_id );
			
			$status = 'wc-' === substr( $this->order_status, 0, 3 ) ? substr( $this->order_status, 3 ) : $this->order_status;
			// Mark as on-hold (we're awaiting the wmbp_pesa)
			$order->update_status( $status, __( 'Checkout with Mobile Banking payment. ', $this->domain ) );

			// Reduce stock levels
			$order->reduce_order_stock();

			// Remove cart
			$woocommerce->cart->empty_cart();

			// Return thankyou redirect
			return array(
				'result' => 'success',
				'redirect' => $this->get_return_url( $order )
			);
		}	


        public function dear_pesa_wmbp_pesa_thankyou_page() {
		    $order_id = get_query_var('order-received');
		    $order = new WC_Order( $order_id );
		    if( $order->payment_method == $this->id ){
	            $thankyou = $this->instructions;
	            return $thankyou;		        
		    } else {
		    	return __( 'Thank you. Your order has been received.', $this->domain );
		    }

        }


        public function dear_pesa_wmbp_pesa_email_instructions( $order, $sent_to_admin, $plain_text = false ) {
		    if( $order->payment_method != $this->id )
		        return;        	
            if ( $this->instructions && ! $sent_to_admin && $this->id === $order->payment_method ) {
                echo wpautop( wptexturize( $this->instructions ) ) . PHP_EOL;
            }
        }

	}

}


/**
 * Empty field validation
 */
add_action( 'woocommerce_checkout_process', 'dear_pesa_wmbp_pesa_payment_process' );
function dear_pesa_wmbp_pesa_payment_process(){

    if($_POST['payment_method'] != 'dear_pesa_wmbp_pesa')
        return;

    $wmbp_pesa_number = sanitize_text_field( $_POST['wmbp_pesa_number'] );
    $wmbp_pesa_transaction_id = sanitize_text_field( $_POST['wmbp_pesa_transaction_id'] );

    if( !isset($wmbp_pesa_number) || empty($wmbp_pesa_number) )
        wc_add_notice( __( 'Please add your M-Pesa Account No.', 'stb'), 'error' );

    if( !isset($wmbp_pesa_transaction_id) || empty($wmbp_pesa_transaction_id) )
        wc_add_notice( __( 'Please add M-Pesa Transaction Ref', 'stb' ), 'error' );

}

/**
 * Update wmbp_pesa field to database
 */
add_action( 'woocommerce_checkout_update_order_meta', 'dear_pesa_wmbp_pesa_additional_fields_update' );
function dear_pesa_wmbp_pesa_additional_fields_update( $order_id ){

    if($_POST['payment_method'] != 'dear_pesa_wmbp_pesa' )
        return;

    $wmbp_pesa_number = sanitize_text_field( $_POST['wmbp_pesa_number'] );
    $wmbp_pesa_transaction_id = sanitize_text_field( $_POST['wmbp_pesa_transaction_id'] );

	$number = isset($wmbp_pesa_number) ? $wmbp_pesa_number : '';
	$transaction = isset($wmbp_pesa_transaction_id) ? $wmbp_pesa_transaction_id : '';

	update_post_meta($order_id, '_wmbp_pesa_number', $number);
	update_post_meta($order_id, '_wmbp_pesa_transaction', $transaction);

}

/**
 * Admin order page wmbp_pesa data output
 */
add_action('woocommerce_admin_order_data_after_billing_address', 'dear_pesa_wmbp_pesa_admin_order_data' );
function dear_pesa_wmbp_pesa_admin_order_data( $order ){
    
    if( $order->payment_method != 'dear_pesa_wmbp_pesa' )
        return;

	$number = (get_post_meta($order->id, '_wmbp_pesa_number', true)) ? get_post_meta($order->id, '_wmbp_pesa_number', true) : '';
	$transaction = (get_post_meta($order->id, '_wmbp_pesa_transaction', true)) ? get_post_meta($order->id, '_wmbp_pesa_transaction', true) : '';

	?>
		<table class="wp-list-table widefat fixed striped posts">
			<tbody>
				<tr>
					<th><?php _e('M-Pesa Account No. of Customer:', 'stb') ;?></th>
					<td><?php echo esc_attr( $number );?></td>
				</tr>
				<tr>
					<th><?php _e('M-Pesa Transaction Ref:', 'stb') ;?></th>
					<td><?php echo esc_attr( $transaction );?></td>
				</tr>
			</tbody>
		</table>
	<?php 
	
}

/**
 * Order review page wmbp_pesa data output
 */
add_action('woocommerce_order_details_after_customer_details', 'dear_pesa_wmbp_pesa_additional_info_order_review_fields' );
function dear_pesa_wmbp_pesa_additional_info_order_review_fields( $order ){
    
    if( $order->payment_method != 'dear_pesa_wmbp_pesa' )
        return;

	$number = (get_post_meta($order->id, '_wmbp_pesa_number', true)) ? get_post_meta($order->id, '_wmbp_pesa_number', true) : '';
	$transaction = (get_post_meta($order->id, '_wmbp_pesa_transaction', true)) ? get_post_meta($order->id, '_wmbp_pesa_transaction', true) : '';

	?>
		<tr>
			<th><?php _e('M-Pesa Account No. of Customer:', 'stb');?></th>
			<td><?php echo esc_attr( $number );?></td>
		</tr>
		<tr>
			<th><?php _e('M-Pesa Transaction Ref:', 'stb');?></th>
			<td><?php echo esc_attr( $transaction );?></td>
		</tr>
	<?php 
	
}	

/**
 * Register new admin column
 */
add_filter( 'manage_edit-shop_order_columns', 'dear_pesa_wmbp_pesa_admin_new_column' );
function dear_pesa_wmbp_pesa_admin_new_column($columns){

    $new_columns = (is_array($columns)) ? $columns : array();
    unset( $new_columns['order_actions'] );
    $new_columns['mobile_no'] = __('Mobile No. of Cutomer', 'stb');
    $new_columns['tran_id'] = __('Tran. ID or Ref. ID', 'stb');

    $new_columns['order_actions'] = $columns['order_actions'];
    return $new_columns;

}

/**
 * Load data in new column
 */
add_action( 'manage_shop_order_posts_custom_column', 'dear_pesa_wmbp_pesa_admin_column_value', 2 );
function dear_pesa_wmbp_pesa_admin_column_value($column){

    global $post;

    $mobile_no = (get_post_meta($post->ID, '_wmbp_pesa_number', true)) ? get_post_meta($post->ID, '_wmbp_pesa_number', true) : '';
    $tran_id = (get_post_meta($post->ID, '_wmbp_pesa_transaction', true)) ? get_post_meta($post->ID, '_wmbp_pesa_transaction', true) : '';

    if ( $column == 'mobile_no' ) {    
        echo esc_attr( $mobile_no );
    }
    if ( $column == 'tran_id' ) {    
        echo esc_attr( $tran_id );
    }
}
